# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.train_api.train_partners.base.prolong_reservation import ProlongReservationType
from travel.rasp.train_api.train_partners.im.base import measurable, get_im_response, parse_datetime

log = logging.getLogger(__name__)

IM_PROLONG_RESERVATION_METHOD = 'Order/V1/Reservation/ProlongReservation'
IM_PROLONG_RESERVATION_TIMEOUT = 5


PROLONG_RESERVATION_VALUE = {
    ProlongReservationType.THREE_HOURS: 'RailwayThreeHoursReservation',
}


@measurable()
def prolong_reservation(order, prolong_reservation_type=ProlongReservationType.THREE_HOURS):
    """
    :param order: заказ train_api.train_purchase.core.models.TrainOrder
    :param prolong_reservation_type: тип продления брони ProlongReservationType
    :return: время (aware) до которого забронированны места
    """
    response = get_im_response(
        IM_PROLONG_RESERVATION_METHOD,
        params={
            'OrderId': order.current_partner_data.im_order_id,
            'ProlongReservationType': PROLONG_RESERVATION_VALUE[prolong_reservation_type]
        },
        credential_id=order.partner_credential_id,
        timeout=IM_PROLONG_RESERVATION_TIMEOUT,
    )
    return parse_datetime(response['ConfirmTill'])
