# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from decimal import Decimal

from django.utils.encoding import force_text

from common.utils.field_masker import FieldMasker
from travel.rasp.train_api.train_partners.base import Tax
from travel.rasp.train_api.train_partners.base.refund_amount import Blank
from travel.rasp.train_api.train_partners.im.base import get_im_response, measurable

log = logging.getLogger(__name__)

RETURN_AMOUNT_ENDPOINT = 'Order/V1/Reservation/ReturnAmount'


field_masker = FieldMasker(mask_fields={
    'ServiceReturnAmountRequest': {
        'CheckDocumentNumber': 1
    }
})


@measurable()
def get_refund_amount(order, doc_number, blank_id=None):
    operation_id = order.current_partner_data.operation_id
    response = get_im_response(RETURN_AMOUNT_ENDPOINT, params={
        'ServiceReturnAmountRequest': {
            '$type': 'ApiContracts.Railway.V1.Messages.Return.RailwayReturnAmountRequest, ApiContracts',
            'OrderItemBlankIds': [int(blank_id)] if blank_id else None,
            'CheckDocumentNumber': doc_number,
            'OrderItemId': int(operation_id)
        }
    }, credential_id=order.partner_credential_id, field_masker=field_masker)

    return [Blank(
        id=force_text(blank['PurchaseOrderItemBlankId']),
        amount=Decimal(blank['Amount']),
        tariff_vat=Tax(rate=Decimal(blank['VatRateValues'][0]['Rate']),
                       amount=Decimal(blank['VatRateValues'][0]['Value'])),
        service_vat=Tax(rate=Decimal(blank['VatRateValues'][1]['Rate']),
                        amount=Decimal(blank['VatRateValues'][1]['Value'])),
        commission_fee_vat=Tax(rate=Decimal(blank['VatRateValues'][2]['Rate']),
                               amount=Decimal(blank['VatRateValues'][2]['Value'])),
        refund_commission_fee_vat=Tax(rate=Decimal(blank['VatRateValues'][3]['Rate']),
                                      amount=Decimal(blank['VatRateValues'][3]['Value']))
    ) for blank in response['ServiceReturnResponse']['Blanks']]
