# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import time as os_time

from travel.rasp.train_api.tariffs.train.im.parser import _get_im_time
from travel.rasp.train_api.train_partners.im.base import IM_DATETIME_FORMAT, ImError, get_im_response, measurable

log = logging.getLogger(__name__)

IM_SCHEDULE_METHOD = 'Railway/V1/Search/Schedule'


@measurable()
def get_schedule_im(point_from_code, point_to_code, departure_date, time_from, time_to, railway_tz):
    params = {
        'Origin': point_from_code,
        'Destination': point_to_code,
        'DepartureDate': departure_date.strftime(IM_DATETIME_FORMAT),
        'TimeFrom': time_from,
        'TimeTo': time_to
    }
    log.info('Спрашиваем Schedule IM. Request params: %r', params)
    start = os_time.time()

    try:
        response = get_im_response(IM_SCHEDULE_METHOD, params)
    except ImError as error:
        if error.is_trains_not_found_error():
            log.info('Расписание не найдено')
            return
        raise

    log.info('Получили ответ за %.3f', os_time.time() - start)

    start_sales_date_times = {schedule.get('StartSalesDateTime', None) for schedule in response['Schedules']}
    return dict(start_sales_date_times=[_get_im_time(dt, railway_tz) for dt in start_sales_date_times if dt])
