# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.field_masker import FieldMasker
from travel.rasp.train_api.train_partners.base.ticket_blank import BlankFormat
from travel.rasp.train_api.train_partners.im.base import get_im_raw_response, measurable


IM_TICKET_PDF_BLANK_ENDPOINT = 'Order/V1/Reservation/Blank'
IM_TICKET_HTML_BLANK_ENDPOINT = 'Railway/V1/Reservation/BlankAsHtml'


@measurable()
def download_ticket_blank(order, operation_id, blank_format=BlankFormat.PDF):
    """
    :type order: common.apps.train_order.models.TrainOrder
    :type operation_id: str
    :type blank_format: BlankFormat
    """

    method = IM_TICKET_PDF_BLANK_ENDPOINT if blank_format == BlankFormat.PDF else IM_TICKET_HTML_BLANK_ENDPOINT
    response = get_im_raw_response(method, {
        'OrderId': order.current_partner_data.im_order_id,
        'OrderItemId': int(operation_id),
    }, credential_id=order.partner_credential_id, field_masker=FieldMasker())
    response.raise_for_status()

    return response.content
