# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api.train_partners.base.update_order import ShortTicketInfo, ShortOrderInfoResult
from travel.rasp.train_api.train_partners.im.base import get_im_response, BLANK_STATUS_TO_RZHD_STATUS, measurable

IM_UPDATE_BLANKS_METHOD = 'Railway/V1/Reservation/UpdateBlanks'


@measurable()
def update_order_info(order):
    response = get_im_response(
        IM_UPDATE_BLANKS_METHOD,
        {'OrderItemId': int(order.current_partner_data.operation_id)},
        credential_id=order.partner_credential_id,
    )
    tickets = []
    for blank in response['Blanks']:
        tickets.append(ShortTicketInfo(
            blank_id=blank['OrderItemBlankId'],
            rzhd_status=BLANK_STATUS_TO_RZHD_STATUS[blank['BlankStatus']],
            pending=blank['PendingElectronicRegistration'] == 'ToCancel'
        ))
    return ShortOrderInfoResult(tickets=tickets)
