# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.lxmlutils import get_sub_tag_text
from travel.rasp.train_api.train_partners.base.confirm_ticket import ConfirmResult
from travel.rasp.train_api.train_partners.ufs.base import get_ufs_response, parse_datetime, measurable


CONFIRM_TICKET_ENDPOINT = 'ConfirmTicket'


@measurable()
def confirm_order(order, site_fee=0, timeout=None):
    tree = get_ufs_response(CONFIRM_TICKET_ENDPOINT, {
        'IdTrans': order.current_partner_data.operation_id,
        'Confirm': 1,
        'lang': order.lang,
        'Site_fee': site_fee
    })

    expire_set_er_xml = tree.find('./ExpireSetEr')
    return ConfirmResult(expire_set_er=None if expire_set_er_xml is None else parse_datetime(expire_set_er_xml),
                         order_num=get_sub_tag_text(tree, './OrderNum'))


@measurable()
def cancel_order(order, partner_data=None, timeout=None):
    get_ufs_response(CONFIRM_TICKET_ENDPOINT, {
        'IdTrans': (partner_data or order.current_partner_data).operation_id,
        'Confirm': 0,
        'lang': order.lang,
        'Site_fee': 0
    })
