# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.train_api.train_partners.ufs.base import get_ufs_response, measurable


log = logging.getLogger(__name__)


ELECTRONIC_REGISTRATION_ENDPOINT = 'ElectronicRegistration'


@measurable()
def change_electronic_registration(order, blank_ids, new_status):
    """
    :return: Status has updated
    """
    # Не делаем проверку, т.к. если регистрация не сменилась, должна кинуться ошибка.
    # Status 1 Deprecated, в случае ошибки всегда есть тег Error
    get_ufs_response(ELECTRONIC_REGISTRATION_ENDPOINT, {
        'IdTrans': order.current_partner_data.operation_id,
        'reg': new_status.value,
        'IdBlank': ','.join(blank_ids),
    })

    return True
