# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from decimal import Decimal

from common.utils.lxmlutils import get_sub_tag_text
from travel.rasp.train_api.train_partners.base.refund import TicketRefundResult, RefundResult, check_refund_error
from travel.rasp.train_api.train_partners.ufs.base import get_ufs_response, measurable

log = logging.getLogger(__name__)

REFUND_ENDPOINT = 'Refund'


@measurable()
def make_refund(order, blank_id, doc_id, reference_id):
    operation_id = order.current_partner_data.operation_id
    params = {'IdTrans': operation_id, 'Doc': doc_id, 'Stan': reference_id}
    if blank_id is not None:
        params['IdBlank'] = blank_id

    with check_refund_error():
        refund_xml = get_ufs_response(REFUND_ENDPOINT, params)

    return _build_result_from_refund_xml(refund_xml)


def _build_result_from_refund_xml(refund_el):
    refund_operation_id = get_sub_tag_text(refund_el, './RefundTransID').strip()
    refund_by_blank_id = {}
    for blank_el in refund_el.findall('./Blank'):
        blank_id = blank_el.get('PrevID', '').strip()
        refund_by_blank_id[blank_id] = TicketRefundResult(
            amount=Decimal(get_sub_tag_text(blank_el, './Amount').strip()),
            refund_blank_id=blank_el.get('ID', '').strip(),
            refund_operation_id=refund_operation_id
        )
    return RefundResult(refund_by_blank_id)
