# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from decimal import Decimal

from common.utils.lxmlutils import get_sub_tag_text
from travel.rasp.train_api.train_partners.base import Tax
from travel.rasp.train_api.train_partners.base.refund_amount import Blank
from travel.rasp.train_api.train_partners.ufs.base import get_ufs_response, measurable

log = logging.getLogger(__name__)

REFUND_AMOUNT_ENDPOINT = 'RefundAmount'


@measurable()
def get_refund_amount(order, doc_number, blank_id=None):
    operation_id = order.current_partner_data.operation_id
    params = {'IdTrans': operation_id, 'Doc': doc_number}
    if blank_id:
        params['IdBlank'] = blank_id

    refund_amount_xml = get_ufs_response(REFUND_AMOUNT_ENDPOINT, params)
    result = []
    for blank_xml in refund_amount_xml.findall('./Blank'):
        try:
            result.append(Blank(
                id=blank_xml.attrib.get('ID'),
                amount=Decimal(get_sub_tag_text(blank_xml, 'Amount', default='').strip()),
                tariff_vat=Tax(rate=Decimal(get_sub_tag_text(blank_xml, 'STV1', default='0').strip()),
                               amount=Decimal(get_sub_tag_text(blank_xml, 'ETF4', default='0').strip())),
                service_vat=Tax(rate=Decimal(get_sub_tag_text(blank_xml, 'STV2', default='0').strip()),
                                amount=Decimal(get_sub_tag_text(blank_xml, 'ETF5', default='0').strip())),
                commission_fee_vat=Tax(rate=Decimal(get_sub_tag_text(blank_xml, 'STV3', default='0').strip()),
                                       amount=Decimal(get_sub_tag_text(blank_xml, 'ETFC', default='0').strip())),
                refund_commission_fee_vat=Tax(rate=Decimal(get_sub_tag_text(blank_xml, 'STV4', default='0').strip()),
                                              amount=Decimal(get_sub_tag_text(blank_xml, 'ETFB', default='0').strip()))
            ))
        except ValueError:
            log.error('Не смогли считать сумму возврата для бланка %s', blank_xml.attrib.get('ID'))
    return result
