# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from travel.rasp.train_api.train_partners.base.ticket_blank import BlankFormat
from travel.rasp.train_api.train_partners.ufs.base import get_raw_ufs_response, measurable

GET_TICKET_BLANK_ENDPOINT = 'GetTicketBlank'


@measurable()
def download_ticket_blank(order, operation_id, blank_format=BlankFormat.PDF):
    """
    :type order: common.apps.train_order.models.TrainOrder
    :type operation_id: str
    :type blank_format: BlankFormat
    """

    params = {
        'terminal': settings.UFS_TERMINAL,
        'format': blank_format.value,
        'idtrans': operation_id
    }
    response = get_raw_ufs_response(GET_TICKET_BLANK_ENDPOINT, params)
    response.raise_for_status()

    return response.content
