# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.utils.lxmlutils import get_sub_tag_text
from travel.rasp.train_api.train_partners.base import RzhdStatus
from travel.rasp.train_api.train_partners.base.update_order import ShortTicketInfo, ShortOrderInfoResult
from travel.rasp.train_api.train_partners.ufs.base import get_ufs_response, measurable

UPDATE_ORDER_INFO_ENDPOINT = 'UpdateOrderInfo'


@measurable()
def update_order_info(order):
    update_order_info_xml = get_ufs_response(UPDATE_ORDER_INFO_ENDPOINT,
                                             {'IdTrans': order.current_partner_data.operation_id})

    tickets = []
    for blank_xml in update_order_info_xml.findall('./Blank'):
        tickets.append(ShortTicketInfo(
            blank_id=blank_xml.attrib.get('ID'),
            rzhd_status=RzhdStatus(int(get_sub_tag_text(blank_xml, 'RzhdStatus').strip())),
            pending=get_sub_tag_text(blank_xml, 'RemoteCheckIn').strip() == '4'
        ))
    return ShortOrderInfoResult(
        tickets=tickets
    )
