# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields


class PendingQuerySchema(Schema):
    minutes_passed = fields.Integer(missing=15, load_from='minutesPassed')


class PendingRefundPaymentSchema(Schema):
    order_uid = fields.String(dump_to='orderUID')
    refund_uuid = fields.String(dump_to='refundUUID')
    refund_payment_status = fields.String(dump_to='refundPaymentStatus')
    refund_created_at = fields.DateTime(dump_to='refundCreatedAt')


class PendingRefundPaymentsResponseSchema(Schema):
    total = fields.Integer()
    payments = fields.Nested(PendingRefundPaymentSchema, many=True)


class RefundMailSchema(Schema):
    order_uid = fields.String(dump_to='orderUID')
    refund_uuid = fields.String(dump_to='refundUUID')
    created_at = fields.DateTime(dump_to='createdAt')
    is_sent = fields.Boolean(dump_to='isSent')


class ErrorSchema(Schema):
    status = fields.String()
    exception = fields.String()
    traceback = fields.String()
