# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields, validates_schema, ValidationError


class TrustPurchaseInfoSchema(Schema):
    purchase_token = fields.String(load_from='purchaseToken', required=True)


class TrustRefundInfoSchema(Schema):
    trust_refund_id = fields.String(load_from='trustRefundId')
    refund_uuid = fields.String(load_from='refundUuid')

    @validates_schema(skip_on_field_errors=False)
    def validate_refund_ids(self, data):
        if not data.get('trust_refund_id') and not data.get('refund_uuid'):
            raise ValidationError('trustRefundId or refundUuid must be specified')
