# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import url
from rest_framework.routers import SimpleRouter

import travel.rasp.train_api.train_purchase.backoffice.support.views as support_views
import travel.rasp.train_api.train_purchase.backoffice.trust_info.views as trust_info_views
from travel.rasp.train_api.train_purchase.backoffice.order_logs import OrderLogsViewSet
from travel.rasp.train_api.train_purchase.backoffice.orders.views import BackofficeOrderViewSet
from travel.rasp.train_api.train_purchase.backoffice.refund.views import BackofficeRefundViewSet

from . import views


backoffice_router = SimpleRouter()
backoffice_router.register('order-logs', OrderLogsViewSet, base_name='order_logs')
backoffice_router.register('orders', BackofficeOrderViewSet, base_name='orders')
backoffice_router.register('refund', BackofficeRefundViewSet, base_name='refund')


urlpatterns = [
    url(r'^pending-refund-payments/$', views.pending_refund_payment),
    url(r'^user-info/$', views.user_info),
    url(r'^trust-info/purchase/$', trust_info_views.purchase_info),
    url(r'^trust-info/refund/$', trust_info_views.refund_info),
    url(r'^support/orders-count-by-email/$', support_views.orders_count_by_email),
]

urlpatterns += backoffice_router.urls
