# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from rest_framework import status
from rest_framework.response import Response

from travel.rasp.library.python.common23.date import environment
from travel.rasp.train_api.train_purchase.backoffice.base import backoffice_api_view
from travel.rasp.train_api.train_purchase.backoffice.serialization import (
    PendingQuerySchema, PendingRefundPaymentsResponseSchema
)
from travel.rasp.train_api.train_purchase.core.models import (
    RefundPayment, RefundPaymentStatus
)


@backoffice_api_view(['GET'])
def user_info(request):
    return Response({
        'username': request.user.username,
        'isActive': request.user.is_active,
        'isAdmin': request.user.is_admin,
    })


@backoffice_api_view(['GET'])
def pending_refund_payment(request):
    """Получить список подвисших возвратов
    ---
    responses:
        200:
            description: Висящие Возвратные Платежи
            schema:
                $ref: 'PendingRefundPaymentsResponseSchema'
    """
    data, errors = PendingQuerySchema().load(request.query_params)
    if errors:
        return Response({
            'errors': errors
        }, status.HTTP_400_BAD_REQUEST)

    payments = RefundPayment.objects.filter(
        refund_created_at__lte=environment.now_utc() - timedelta(minutes=data['minutes_passed']),
        refund_payment_status__nin=(RefundPaymentStatus.FAILED, RefundPaymentStatus.DONE)
    ).order_by('refund_created_at')

    return Response(PendingRefundPaymentsResponseSchema().dump({
        'total': payments.count(),
        'payments': payments
    }).data)
