# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from collections import namedtuple
from enum import Enum

from common.dynamic_settings.default import conf
from travel.rasp.library.python.common23.date import environment

log = logging.getLogger(__name__)


class AgeGroup(Enum):
    BABIES = 'babies'
    CHILDREN = 'children'
    ADULTS = 'adults'


class DocumentType(Enum):
    RUSSIAN_PASSPORT = 'ПН'
    BIRTH_CERTIFICATE = 'СР'
    RUSSIAN_INTERNATIONAL_PASSPORT = 'ЗП'
    FOREIGN_DOCUMENT = 'ЗЗ'
    SAILOR_PASSPORT = 'ПМ'
    MILITARY_CARD = 'ВБ'


class Gender(Enum):
    MALE = 'M'
    FEMALE = 'F'


class GenderChoice(Enum):
    MALE = 'male'
    FEMALE = 'female'
    MIXED = 'mixed'


class LoyaltyCardType(Enum):
    RZHD_BONUS = 'RzhdB'
    UNIVERSAL = 'RzhdU'  # Дорожная карта «Универсальная»


class PlacesOption(Enum):
    WITH_PET = 'with_pet'


class Arrangement(Enum):
    COMPARTMENT = 'compartment'  # купе
    SECTION = 'section'  # отсек
    NEAREST = 'nearest'  # рядом
    NOT_SIDE = 'notSide'  # не боковые


class PlacesType(Enum):
    LOWER_TIER = 'lower_tier'
    UPPER_TIER = 'upper_tier'
    MIDDLE_TIER = 'middle_tier'
    FOR_PASSENGER_WITH_PET = 'for_passenger_with_pet'
    FOR_MOTHER_WITH_CHILD = 'for_mother_with_child'
    FOR_PASSENGER_WITH_CHILDREN = 'for_passenger_with_children'
    FOR_IMPAIRED_PASSENGER = 'for_impaired_passenger'
    CONFERENCE_ROOM = 'conference_room'
    NOT_NEAR_TABLE = 'not_near_table'
    NEAR_TABLE = 'near_table'
    NEAR_PLAYGROUND = 'near_playground'
    NEAR_PLAYGROUND_TABLE = 'near_playground_table'
    NEAR_PASSENGERS_WITH_PETS = 'near_passengers_with_pets'
    FOLDING = 'folding'
    LASTOCHKA_COMPARTMENT = 'lastochka_compartment'


IsPartnerActiveCacheValue = namedtuple('IsPartnerActiveCache', ('is_active', 'updated_at'))
_is_partner_active_cache = {}


def clear_is_partner_active_cache():
    global _is_partner_active_cache
    _is_partner_active_cache = {}


class TrainPartner(Enum):
    IM = 'im'
    UFS = 'ufs'

    @property
    def enabled(self):
        return self.value in conf.TRAN_PURCHASE_ENABLED_PARTNERS.split()

    @property
    def is_active(self):
        global _is_partner_active_cache

        if not self.enabled:
            return False

        now = environment.now()
        # Нужно вычислять заново при смене даты по Москве.
        if self not in _is_partner_active_cache or not _is_partner_active_cache[self].updated_at.date() == now.date():
            from travel.rasp.train_api.train_purchase.core.models import ClientContracts

            _is_partner_active_cache[self] = IsPartnerActiveCacheValue(
                is_active=ClientContracts.get_active_contract(self) is not None,
                updated_at=now
            )
            log.info('Обновили кэш активных контрактов для партнера %s, новое значение %s',
                     self, _is_partner_active_cache[self].is_active)
        return _is_partner_active_cache[self].is_active


class TrainPartnerCredentialId(Enum):
    IM = 'im'
    IM_SUBURBAN = 'im_suburban'


class OrderStatus(Enum):
    RESERVED = 'reserved'
    CANCELLED = 'cancelled'
    START_PAYMENT_FAILED = 'start_payment_failed'
    PAYMENT_FAILED = 'payment_failed'
    PAYMENT_OUTDATED = 'payment_outdated'
    CONFIRM_FAILED = 'confirm_failed'
    REBOOKING_FAILED = 'rebooking_failed'
    PAID = 'paid'
    DONE = 'done'


class TrainPurchaseSource(Enum):
    DESKTOP = 'desktop'
    TOUCH = 'touch'


class TrainOrderUrlOwner(Enum):
    TRAINS = 'trains'
    UFS = 'ufs'


class OperationStatus(Enum):
    OK = 'OK'
    FAILED = 'FAILED'
    IN_PROCESS = 'IN_PROCESS'


class RebookingStatus(Enum):
    DISABLED = 'disabled'
    IN_PROCESS = 'in_process'
    DONE = 'done'
    FAILED = 'failed'
    SKIPPED = 'skipped'
    OVERLIMIT = 'overlimit'
    INVALID_ORDER = 'invalid_order'
    MISMATCH = 'mismatch'


class TravelOrderStatus(Enum):
    RESERVED = 'Reserved'
    IN_PROGRESS = 'In progress'
    DONE = 'Done'
    CANCELLED = 'Cancelled'
    UNKNOWN = 'Unknown'


class OrderWarningCode(Enum):
    TICKETS_TAKEN_AWAY = 'tickets_taken_away'
    ELECTRONIC_REGISTRATION_EXPIRED = 'electronic_registration_expired'
    ELECTRONIC_REGISTRATION_ALMOST_EXPIRED = 'electronic_registration_almost_expired'
    TRAIN_LEFT_START_STATION = 'train_left_start_station'
    TRAIN_LEFT_DEPARTURE_STATION = 'train_left_departure_station'
    TRAIN_ALMOST_LEFT_DEPARTURE_STATION = 'train_almost_left_departure_station'
    INSURANCE_AUTO_RETURN = 'insurance_auto_return'


class InsuranceStatus(Enum):
    ACCEPTED = 'accepted'
    DECLINED = 'declined'
    CHECKING_OUT = 'checking_out'
    CHECKED_OUT = 'checked_out'
    FAILED = 'failed'


class RoutePolicy(Enum):
    INTERNAL = 'internal'
    INTERNATIONAL = 'international'
    FINLAND = 'finland'
    SUBURBAN = 'suburban'
    CPPK = 'cppk'


class AgeCode(Enum):
    FULL = 'full'
    BABY = 'baby'
    CHILD = 'child'
