# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import random
import time as os_time

import six

from common.data_api.yasms.client import YaSMSClient
from travel.rasp.library.python.common23.date import environment
from common.utils import lock as mongolock
from travel.rasp.train_api.train_purchase.core import config
from travel.rasp.train_api.train_purchase.core.models import TrainPurchaseSmsVerification

log = logging.getLogger(__name__)


@six.python_2_unicode_compatible
class SmsThrottlingError(Exception):
    def __init__(self, last_sms):
        self.last_sms = last_sms

    def __str__(self):
        return 'Can send next after {}'.format(self.last_sms.can_send_next_after)


def get_random_sms_code():
    random.seed(os_time.time())

    # Как минимум 3 уникальных символа, чтобы избежать простых кодов типа, 1000
    while True:
        # меньше 0012 и больше 9987 содержат меньше 3 различных знаков
        code = '{:04d}'.format(random.randint(12, 9987))
        if len(set(code)) >= 3:
            break

    return code


def send_verification_sms(phone, action_name, message_template, action_data=None):
    with mongolock.Lock('train_purchase_sms_verification_{}'.format(phone), collection='train_order_locks',
                        expire=config.TRAIN_PURCHASE_VERIFICATION_SMS_LOCK_TIMEOUT,
                        renew_interval=config.TRAIN_PURCHASE_VERIFICATION_SMS_LOCK_TIMEOUT // 2,
                        database_name='train_purchase'):
        last_live_sms = TrainPurchaseSmsVerification.get_latest_live_sms(phone, action_name)
        if last_live_sms and not last_live_sms.can_send_next:
            raise SmsThrottlingError(last_live_sms)

        code = get_random_sms_code()
        message = message_template.format(code=code)
        action_data = action_data or {}

        log.info('Посылаем SMS c верификацией: %s "%s"', phone, message)
        yasms_id = YaSMSClient().sendsms(message, phone=phone)
        sms_verification = TrainPurchaseSmsVerification(phone=phone, code=code, message=message,
                                                        action_name=action_name,
                                                        action_data=action_data,
                                                        sent_at=environment.now(), yasms_id=yasms_id)
        sms_verification.save()

        return sms_verification
