# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import datetime

import factory
import pytz
from factory import DictFactory

from common.apps.train.models import TariffInfo
from common.apps.train_order.enums import CoachType
from common.models.geo import Country
from common.tester.factories import create_station
from common.utils.date import UTC_TZ
from travel.rasp.train_api.helpers.factory import fix_list_subfactory
from travel.rasp.train_api.train_purchase.core.enums import (
    AgeGroup, TrainPartner, Gender, DocumentType, TrainPartnerCredentialId, OrderWarningCode
)


class ReserveOrderDataPassengerFactory(DictFactory):
    first_name = factory.Faker('first_name')
    last_name = factory.Faker('last_name')
    patronymic = None
    sex = Gender.MALE
    doc_type = DocumentType.RUSSIAN_PASSPORT
    doc_id = '6500112233'
    birth_date = factory.Faker('date_time')
    age_group = AgeGroup.ADULTS
    phone = '79222020123'
    email = 'email@email.com'
    tariff_info = factory.LazyAttribute(  # TODO: принимать код и по нему строить TariffInfo
        lambda _x: TariffInfo.objects.get_or_create(
            code=TariffInfo.FULL_CODE,
            defaults=dict(
                title_ru='Полный',
                ufs_request_code='1',
                ufs_response_codes='ПОЛНЫЙ, 72 ADULT, 71 ВЗР/ADULT, 71 ADULT',
                im_request_code='Full',
                im_response_codes='Full',
            )
        )[0]
    )
    citizenship_country = Country.objects.get(code='RU')
    loyalty_card = None
    loyalty_cards = []


class ReserveOrderDataPlaceFactory(DictFactory):
    number = 10
    is_upper = False


class ReserveOrderDataUserInfoFactory(DictFactory):
    email = 'user@example.com'
    is_mobile = False
    phone = '+7555555555'
    ip = '127.0.0.1'
    uid = '123123123123'
    region_id = 54


class ReserveOrderDataRequirementsCountFactory(DictFactory):
    bottom = None
    upper = None
    near_window = None
    near_passage = None


class ReserveOrderDataRequirementsFactory(DictFactory):
    storey = 0
    arrangement = None
    count = factory.SubFactory(ReserveOrderDataRequirementsCountFactory)


class ReserveOrderDataFactory(DictFactory):
    partner = TrainPartner.IM
    partner_credential_id = TrainPartnerCredentialId.IM
    train_number = '001Я'
    train_ticket_number = '002Я'
    train_name = None
    departure = factory.Faker('date_time', tzinfo=pytz.UTC)
    arrival = factory.Faker('date_time', tzinfo=pytz.UTC)
    coach_type = CoachType.COMPARTMENT
    gender = None
    user_info = factory.SubFactory(ReserveOrderDataUserInfoFactory)
    two_storey = False

    passengers = factory.List([
        factory.SubFactory(ReserveOrderDataPassengerFactory)
    ])
    station_from = factory.LazyAttribute(lambda _x: create_station())
    station_to = factory.LazyAttribute(lambda _x: create_station())
    electronic_registration = False
    coach_number = '02'
    service_class = '2Я'
    international_service_class = '1/2'
    is_cppk = False

    places = factory.List([
        factory.SubFactory(ReserveOrderDataPlaceFactory)
    ])
    place_demands = None
    requirements = factory.SubFactory(ReserveOrderDataRequirementsFactory)
    additional_place_requirements = None

    bedding = False
    bedding_tariff = None
    order_history = None
    source = factory.LazyAttribute(lambda _x: {})
    experiment = None
    give_child_without_place = False

    @classmethod
    def create(cls, **kwargs):
        fix_list_subfactory('passengers', ReserveOrderDataPassengerFactory, kwargs)
        fix_list_subfactory('places', ReserveOrderDataPlaceFactory, kwargs)
        return super(ReserveOrderDataFactory, cls).create(**kwargs)


def create_order_warnings():
    return [
        {
            'from': datetime(2019, 1, 1, 20, 00, tzinfo=UTC_TZ),
            'to': datetime(2019, 1, 1, 21, 00, tzinfo=UTC_TZ),
            'code': OrderWarningCode.INSURANCE_AUTO_RETURN.value,
        },
        {
            'code': OrderWarningCode.TICKETS_TAKEN_AWAY.value,
        },
    ]
