# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from ylog.context import log_context

from common.celery.task import single_launch_task
from travel.rasp.library.python.common23.date.environment import now_aware
from travel.rasp.train_api.train_partners.base.confirm_ticket import cancel_order
from travel.rasp.train_api.train_purchase.core.enums import OrderStatus
from travel.rasp.train_api.train_purchase.core.models import TrainOrder

log = logging.getLogger(__name__)

# период обрабатываемых заказов
ORDER_FILTER_INTERVAL = timedelta(minutes=20)
# статусы заказа для которых не вызываем отмену бронирования
ORDER_STATUSES_TO_SKIP_CANCEL = [OrderStatus.DONE, OrderStatus.PAID]


@single_launch_task()
def find_and_cancel_expired_orders(interval=ORDER_FILTER_INTERVAL):
    end_dt = now_aware()

    order_qs = TrainOrder.objects.filter(
        reserved_to__gt=end_dt - interval, reserved_to__lt=end_dt,
        status__nin=ORDER_STATUSES_TO_SKIP_CANCEL,
        partner_data_history__is_order_cancelled=False,
    )
    for order in order_qs:
        with log_context(order_uid=order.uid):
            for ln, pd in order.iter_lookup_partner_data():
                if pd.is_order_cancelled:
                    continue
                try:
                    cancel_order(order, pd)
                    order.modify(**{'set__{}__is_order_cancelled'.format(ln): True})
                except Exception:
                    log.exception('error in cancel order, reservation_datetime={}'.format(pd.reservation_datetime))
