# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from decimal import Decimal

from django.conf import settings

from common.celery.task import single_launch_task
from common.dynamic_settings.default import conf
from common.email_sender import guaranteed_send_email
from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.train_api.train_partners.im.partner_balance import get_partner_balance
from travel.rasp.train_api.train_purchase.core.enums import TrainPartner
from travel.rasp.train_api.train_purchase.core.models import PartnerBalance

log = logging.getLogger(__name__)

define_setting('PARTNER_BALANCE_ALERT_CAMPAIGN', {
    Configuration.PRODUCTION: '0OQDNAB3-V7K1',
    Configuration.TESTING: 'KPU9MAB3-BAI1',
}, default=None)


@single_launch_task()
def check_im_balance():
    last = PartnerBalance.get_partner_balance(TrainPartner.IM)
    limit = Decimal(conf.TRAIN_PURCHASE_IM_BALANCE_THRESHOLD)
    current = get_partner_balance()
    now = now_utc()
    if current < limit:
        log.error('Im balance {} is less than limit {}'.format(current, limit))
        if last.balance >= limit:
            guaranteed_send_email(
                key='check_im_balance_{}'.format(now),
                to_email=conf.TRAIN_PURCHASE_ERRORS_EMAIL,
                args={
                    'limit': str(limit),
                    'current': str(current),
                    'partner': TrainPartner.IM.value
                },
                campaign=settings.PARTNER_BALANCE_ALERT_CAMPAIGN,
            )
    last.balance = current
    last.updated_at = now
    last.save()
