from common.celery.task import single_launch_task
from common.dynamic_settings.default import conf
from travel.rasp.train_api.helpers.rps_limiter import (
    rps_limiter, RPS_LIMITER_IM_SEARCH_KEY, RPS_LIMITER_IM_CARPRICING_KEY
)


@single_launch_task()
def do_clean_tokens():
    if conf.TRAIN_PURCHASE_IM_RPS_LIMITER_ENABLED:
        rps_limiter.clean_tokens(RPS_LIMITER_IM_SEARCH_KEY,
                                 conf.TRAIN_PURCHASE_IM_SEARCH_RPS_LIMIT,
                                 conf.TRAIN_PURCHASE_IM_RPS_LIMITER_PERIOD)
        rps_limiter.clean_tokens(RPS_LIMITER_IM_CARPRICING_KEY,
                                 conf.TRAIN_PURCHASE_IM_CARPRICING_RPS_LIMIT,
                                 conf.TRAIN_PURCHASE_IM_RPS_LIMITER_PERIOD)
