# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from common.celery.task import single_launch_task
from common.data_api.billing.trust_client import TrustPaymentStatuses
from common.dynamic_settings.default import conf
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.train_api.train_purchase.core.models import Payment
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_payment
from travel.rasp.train_api.train_purchase.workflow.user_events import PaymentUserEvents

log = logging.getLogger(__name__)


@single_launch_task()
def start_clear_payments():
    _start_clear_payments(conf.TRAIN_PURCHASE_PAYMENT_CLEAR_DELAY_HOURS, 48)


def _start_clear_payments(clear_delay_hours, payment_search_range_hours):
    created_end = now_utc() - timedelta(hours=clear_delay_hours)
    created_start = created_end - timedelta(hours=payment_search_range_hours)
    for payment in get_top_payments_to_clear(created_start, created_end):
        send_event_to_payment(payment, PaymentUserEvents.CONFIRM_PAYMENT)


def get_top_payments_to_clear(created_start, created_end):
    return Payment.objects.filter(
        status=TrustPaymentStatuses.AUTHORIZED.value,
        trust_created_at__gte=created_start,
        trust_created_at__lt=created_end,
        clear_at__exists=False,
    ).order_by('-trust_created_at')[:500]
