# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from ylog.context import log_context

from common.celery.task import single_launch_task
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.train_api.train_purchase.core.models import TrainOrder
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_order
from travel.rasp.train_api.train_purchase.workflow.booking.update_expired_order import PAID_ORDER_STATUSES
from travel.rasp.train_api.train_purchase.workflow.user_events import TrainBookingUserEvents

log = logging.getLogger(__name__)

# период обрабатываемых заказов
EXPIRED_ORDERS_PROCESS_DEPTH = timedelta(minutes=10)


@single_launch_task()
def set_orders_expired(interval=EXPIRED_ORDERS_PROCESS_DEPTH):
    for order in find_orders(interval):
        with log_context(order_uid=order.uid):
            order.modify(set__is_order_expired=True)
            send_event_to_order(order, TrainBookingUserEvents.ORDER_EXPIRE, allow_send_to_empty_process=True)


def find_orders(interval):
    end_dt = now_utc()

    order_qs = TrainOrder.objects.filter(
        reserved_to__gt=end_dt - interval, reserved_to__lt=end_dt,
        status__nin=PAID_ORDER_STATUSES,
        is_order_expired__ne=True
    )
    return order_qs
