# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from bson import ObjectId
from django.conf import settings

from common.celery.task import single_launch_task
from common.settings.utils import define_setting
from travel.rasp.library.python.common23.date import environment
from travel.rasp.train_api.train_purchase.core.models import RefundBlank

define_setting('REFUND_BLANKS_TTL', default=timedelta(minutes=15))


@single_launch_task()
def collect_outdated_refund_blanks():
    refund_blanks_ttl = settings.REFUND_BLANKS_TTL
    if refund_blanks_ttl is None:
        return

    remove_from = ObjectId.from_datetime(environment.now_utc() - refund_blanks_ttl)
    RefundBlank.objects(pk__lte=remove_from).delete()
