# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from ylog.context import log_context

from common.celery.task import single_launch_task
from travel.rasp.train_api.train_purchase.core.models import RefundPaymentStatus, RefundPayment
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_payment
from travel.rasp.train_api.train_purchase.workflow.user_events import PaymentUserEvents

log = logging.getLogger(__name__)


MAX_NUMBER_OF_TRY_LATER_REFUND_PAYMENTS_TO_PROCESS = 500


@single_launch_task()
def retry_refund_payment():
    for pending_refund_payment in get_top_refund_payments_to_retry():
        with log_context(order_uid=pending_refund_payment.order_uid):
            _start_retry(pending_refund_payment)


def get_top_refund_payments_to_retry():
    return RefundPayment.objects.filter(
        refund_payment_status=RefundPaymentStatus.NEW
    ).order_by('-refund_created_at')[:MAX_NUMBER_OF_TRY_LATER_REFUND_PAYMENTS_TO_PROCESS]


def _start_retry(pending_refund_payment):
    payment = pending_refund_payment.payment
    send_event_to_payment(payment, PaymentUserEvents.REFUND_PAYMENT, params=pending_refund_payment.id)
