# coding: utf8

from __future__ import unicode_literals, absolute_import, division, print_function

import logging
from datetime import timedelta

from ylog.context import log_context

from common.celery.task import single_launch_task
from travel.rasp.library.python.common23.date.environment import now_utc
from travel.rasp.train_api.train_purchase.core.models import RefundEmail, TrainRefund
from travel.rasp.train_api.train_purchase.utils.refund_email import send_refund_email

log = logging.getLogger(__name__)

MAX_NUMBER_OF_REFUNDS_TO_CLOSE_INTENT = 50
WAIT_INTERVAL_FOR_RESEND = timedelta(minutes=10)


# TODO: obsolete, remove this
@single_launch_task()
def close_refund_email_intents():
    refund_email_query = RefundEmail.objects(is_sent=False,
                                             created_at__lte=now_utc() - WAIT_INTERVAL_FOR_RESEND)
    number_of_unsent_refund_emails = refund_email_query.count()
    log.info('Обрабатываем %s из %s неотправленных писем о возврате.',
             min(number_of_unsent_refund_emails, MAX_NUMBER_OF_REFUNDS_TO_CLOSE_INTENT), number_of_unsent_refund_emails)
    refund_emails = refund_email_query.order_by('-created_at')[:MAX_NUMBER_OF_REFUNDS_TO_CLOSE_INTENT]
    for refund_email in refund_emails:
        with log_context(order_uid=refund_email.order_uid):
            try:
                refund = TrainRefund.objects.get(uuid=refund_email.refund_uuid)
                send_refund_email(refund)
                RefundEmail.mark_success(refund_email.order_uid, refund_email.refund_uuid)
            except Exception:
                log.exception('Ошибка при досылке письма о возврате')
