# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.celery.task import single_launch_task
from travel.rasp.train_api.train_purchase.core.models import Payment, TrainOrder, TrainRefund
from travel.rasp.train_api.train_purchase.utils.reviver_with_filter import revive
from travel.rasp.train_api.train_purchase.workflow.booking import TRAIN_BOOKING_PROCESS
from travel.rasp.train_api.train_purchase.workflow.payment import PAYMENT_PROCESS
from travel.rasp.train_api.train_purchase.workflow.ticket_refund import TICKET_REFUND_PROCESS

REVIVE_FREQUENCY = 10.0  # seconds


@single_launch_task(expire=REVIVE_FREQUENCY)
def revive_ticket_refund_processes():
    def get_refund_log_context(mongo_obj):
        refund = TrainRefund.objects.get(id=mongo_obj['_id'])
        return {'order_uid': refund.order_uid}

    revive(TICKET_REFUND_PROCESS, {'expiration': REVIVE_FREQUENCY},
           log_context_getter=get_refund_log_context,)


@single_launch_task(expire=REVIVE_FREQUENCY)
def revive_train_booking_processes():
    def get_booking_log_context(mongo_obj):
        order = TrainOrder.objects.get(id=mongo_obj['_id'])
        return {'order_uid': order.uid}

    revive(
        TRAIN_BOOKING_PROCESS, {'expiration': REVIVE_FREQUENCY},
        log_context_getter=get_booking_log_context,
        additional_filter={'process.suspended': {'$ne': True}},
    )


@single_launch_task(expire=REVIVE_FREQUENCY)
def revive_train_payment_processes():
    def get_payment_log_context(mongo_obj):
        payment = Payment.objects.get(id=mongo_obj['_id'])
        return {'order_uid': payment.order_uid}

    revive(PAYMENT_PROCESS, {'expiration': REVIVE_FREQUENCY},
           log_context_getter=get_payment_log_context,
           additional_filter={'process.state': {'$exists': True}})
