# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings

from common.celery.task import single_launch_task
from common.data_api.billing.trust_client import TrustClient, TrustClientException
from common.settings.configuration import Configuration
from travel.rasp.train_api.train_purchase.utils.billing import BILLING_PARTNERS, BILLING_PRODUCTS

log = logging.getLogger(__name__)


@single_launch_task()
def create_partners_and_products():
    trust_client = TrustClient()
    _create_products(trust_client, _create_partners(trust_client))


def _create_partners(trust_client):
    partner_to_partner_id = {}
    for partner, billing_partner in BILLING_PARTNERS.items():
        billing_partner_id = billing_partner.id
        try:
            if not trust_client.is_partner_exist(billing_partner_id):
                if settings.YANDEX_ENVIRONMENT_TYPE == Configuration.TESTING:
                    # XXX в testing'е мы можем создавать партнеров со случайным id.
                    billing_partner_id = trust_client.create_partner()
                    log.info('Создали партнёра %s (id=%r)', partner, billing_partner_id)
                else:
                    log.error('Нет партнера с id %s', billing_partner_id)
        except TrustClientException:
            log.exception('Не удалось создать партнёра %s', partner)
        partner_to_partner_id[partner] = billing_partner_id
    return partner_to_partner_id


def _create_products(trust_client, partner_to_partner_id):
    for product in BILLING_PRODUCTS:
        for partner, product_id in product.partner_to_id.items():
            try:
                if not trust_client.is_product_exist(product_id):
                    trust_client.create_product(
                        partner_id=partner_to_partner_id[partner],
                        service_fee=product.service_fee,
                        product_name=product.name,
                        product_id=product_id
                    )
                    log.info('Создали продукт %s для партнёра %s (id=%r)', product, partner, product_id)
            except TrustClientException:
                log.exception('Не удалось создать продукт %s для партнёра %s', product, partner)
