# coding: utf-8

from __future__ import unicode_literals, absolute_import, division, print_function

from logging import getLogger

from common.utils.date import naive_to_timestamp
from travel.rasp.library.python.common23.date.environment import now_utc

bandit_train_details_log = getLogger('bandit_train_details_logger')
log = getLogger(__name__)


def log_data(data):
    data = {
        'timestamp': naive_to_timestamp(now_utc()),
        'test_buckets': data.get('test_buckets'),
        'req_id': data.get('req_id'),
        'icookie': data.get('icookie'),
        'yandex_uid': data.get('yandex_uid'),
        'point_from': data.get('station_from').point_key,
        'point_to': data.get('station_to').point_key,
        'departure_dt': naive_to_timestamp(data.get('departure').replace(tzinfo=None)),
        'arrival_dt': naive_to_timestamp(data.get('arrival').replace(tzinfo=None)),
        'station_from_id': data.get('station_from').id,
        'station_to_id': data.get('station_to').id,
        'train_type': data.get('train_type'),
        'car_type': data.get('car_type'),
        'service_class': data.get('service_class'),
        'price': float(data.get('price')),
        'event_type': data.get('event_type'),
    }
    bandit_train_details_log.info(msg=None, extra=data)
