# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from collections import namedtuple

from common.data_api.billing.helpers import download_receipt
from common.data_api.billing.trust_client import FiscalTaxationType, TrustReceiptException
from travel.rasp.train_api.train_purchase.core.models import TrainPartner

BillingPartner = namedtuple('BillingPartner', ('id', 'inn', 'phone', 'taxation_type'))
BillingProduct = namedtuple('BillingProduct', ('name', 'service_fee', 'partner_to_id'))

# TODO taxation_type
BILLING_PARTNERS = {
    TrainPartner.IM: BillingPartner(id=33513955,
                                    inn='9717045555',
                                    phone='+74994902558',
                                    taxation_type=FiscalTaxationType.OSN),
    TrainPartner.UFS: BillingPartner(id=32550570,
                                     inn='7708510731',
                                     phone='+74952698365',
                                     taxation_type=FiscalTaxationType.OSN)
}

BILLING_PRODUCT_TICKET = BillingProduct('Услуги перевозки пассажира ж/д транспортом', service_fee=0,
                                        partner_to_id={TrainPartner.IM: 'im_ticket', TrainPartner.UFS: 'ufs_ticket'})
BILLING_PRODUCT_SERVICE = BillingProduct('Дополнительные услуги перевозчика', service_fee=0, partner_to_id={
    TrainPartner.IM: 'im_service',
    TrainPartner.UFS: 'ufs_service'
})
BILLING_PRODUCT_YANDEX_FEE = BillingProduct('Сервисный сбор', service_fee=1, partner_to_id={
    TrainPartner.IM: 'im_rasp_fee',
    TrainPartner.UFS: 'ufs_rasp_fee'
})
BILLING_PRODUCT_INSURANCE = BillingProduct(
    'Страхование поездки (страховая премия)',
    service_fee=2,
    partner_to_id={
        TrainPartner.IM: 'im_insurance',
        TrainPartner.UFS: 'ufs_insurance'
    },
)

BILLING_PRODUCTS = (
    BILLING_PRODUCT_TICKET,
    BILLING_PRODUCT_SERVICE,
    BILLING_PRODUCT_YANDEX_FEE,
    BILLING_PRODUCT_INSURANCE,
)


def download_order_receipt(order):
    return download_receipt(purchase_token=order.current_billing_payment.purchase_token)


def download_refund_receipt(refund_payment):
    if refund_payment:
        if not refund_payment.payment_resized:
            receipt = download_receipt(purchase_token=None, refund_id=refund_payment.trust_refund_id)
        else:
            receipt = download_receipt(purchase_token=refund_payment.purchase_token, resize=True)
        return receipt

    raise TrustReceiptException('Невозможно получить чек, возврат не завершен')
