from __future__ import unicode_literals, absolute_import, division, print_function

from enum import Enum

from travel.rasp.train_api.train_partners.base import RzhdStatus


class RegistrationStatus(Enum):
    DISABLED = 0
    ENABLED = 1


class WrongBlankIdError(Exception):
    pass


def _need_to_change_registration(current_rzhd_status, new_status):
    if new_status == RegistrationStatus.ENABLED and current_rzhd_status == RzhdStatus.REMOTE_CHECK_IN:
        return False

    if new_status == RegistrationStatus.DISABLED and current_rzhd_status == RzhdStatus.NO_REMOTE_CHECK_IN:
        return False
    return True


def get_blank_ids_to_change_er(order, blank_ids, new_status):
    blank_ids_to_change = []

    blank_ids = set(blank_ids)
    for ticket in order.iter_tickets():
        if ticket.blank_id not in blank_ids:
            continue

        blank_ids.remove(ticket.blank_id)
        current_rzhd_status = RzhdStatus(ticket.rzhd_status)
        if not current_rzhd_status.is_possible_to_change_er_status():
            raise WrongBlankIdError("Couldn't change er for {t.blank_id} with status {t.rzhd_status}".format(t=ticket))

        if not _need_to_change_registration(current_rzhd_status, new_status):
            continue

        blank_ids_to_change.append(ticket.blank_id)

    if blank_ids:
        raise WrongBlankIdError('No blanks with ids {}'.format(','.join(blank_ids)))

    return blank_ids_to_change


def _registration_to_rzhd_status(status):
    return {
        RegistrationStatus.ENABLED: RzhdStatus.REMOTE_CHECK_IN,
        RegistrationStatus.DISABLED: RzhdStatus.NO_REMOTE_CHECK_IN
    }.get(status)


def update_tickets_er_status(order, blank_ids, new_status):
    update_spec = {}
    for ticket, lookup_name in order.iter_ticket_to_lookup_name():
        if ticket.blank_id in blank_ids:
            update_spec['set__' + lookup_name + '__rzhd_status'] = _registration_to_rzhd_status(new_status)

    if update_spec:
        order.modify(**update_spec)


def set_tickets_pending_status(order, blank_ids):
    update_spec = {}
    for ticket, lookup_name in order.iter_ticket_to_lookup_name():
        if ticket.blank_id in blank_ids:
            update_spec['set__' + lookup_name + '__pending'] = True

    if update_spec:
        order.modify(**update_spec)
