# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.dynamic_settings.default import conf
from common.email_sender import guaranteed_send_email
from common.settings.configuration import Configuration
from common.settings.utils import define_setting

define_setting('EMAIL_INTENT_ERRORS_CAMPAIGN', {
    Configuration.PRODUCTION: 'GK0LR9U2-0341',
    Configuration.TESTING: '8Q7GR9U2-LWB1',
    Configuration.DEVELOPMENT: '8Q7GR9U2-LWB1'
}, default=None)


define_setting('EMAIL_SEND_ERROR_CAMPAIGN', {
    Configuration.PRODUCTION: 'OGY57AB3-32C',
    Configuration.TESTING: 'K36WW8B3-JY7',
    Configuration.DEVELOPMENT: 'K36WW8B3-JY7'
}, default=None)


def report_fail_email(failed_email_intent):
    """
    :param failed_email_intent: common.email_sender.models.EmailIntent
    """
    email = conf.TRAIN_PURCHASE_ERRORS_EMAIL
    error_message = 'Слишком долго не могли отправить письмо {}'.format(failed_email_intent.id)
    if 'order_uid' in failed_email_intent.data:
        error_message += ' для заказа {}'.format(failed_email_intent.data['order_uid'])
    guaranteed_send_email(
        key='failed_email_intent_{}'.format(failed_email_intent.key),
        to_email=email,
        args={'error_message': error_message},
        campaign=settings.EMAIL_INTENT_ERRORS_CAMPAIGN,
        data=failed_email_intent.data,
        log_context=failed_email_intent.log_context,
    )


def report_error_email(email_intent, error_details):
    """
    :param error_details: str
    :param email_intent: common.email_sender.models.EmailIntent
    """
    guaranteed_send_email(
        key='error_send_email_intent_{}'.format(email_intent.key),
        to_email=conf.TRAIN_PURCHASE_ERRORS_EMAIL,
        args={
            'order_uid': email_intent.data['order_uid'],
            'error_details': error_details,
            'email_intent_id': str(email_intent.id),
        },
        campaign=settings.EMAIL_SEND_ERROR_CAMPAIGN,
        data=email_intent.data,
        log_context=email_intent.log_context,
    )
