# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from rest_framework.pagination import LimitOffsetPagination


class MultipleQuerySetsPagination(LimitOffsetPagination):
    def __init__(self):
        super(LimitOffsetPagination, self).__init__()

        self.limit = None
        self.offset = None
        self.count = None
        self.request = None

    @classmethod
    def _get_count(cls, queryset):
        """
        Determine an object count, supporting either querysets or regular lists.
        """
        try:
            return queryset.count()
        except (AttributeError, TypeError):
            return len(queryset)

    def paginate_querysets(self, querysets, request):
        self.limit = self.get_limit(request)
        if self.limit is None:
            return None

        self.offset = self.get_offset(request)
        self.count = sum(self._get_count(qs) for qs in querysets)
        self.request = request

        if self.count > self.limit and self.template is not None:
            self.display_page_controls = True

        if self.count == 0 or self.offset > self.count:
            return []

        result = []
        index = 0
        for qs in querysets:
            count = self._get_count(qs)
            prev_index = index
            index += count

            if index < self.offset:
                continue
            elif prev_index > self.offset + self.limit:
                break
            else:
                begin = self.offset - prev_index
                end = count + self.offset + self.limit - index
                sliced = qs[begin if begin > 0 else 0:end if end > 0 else 0]
                result.extend(sliced)

        return result
