# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.workflow.reviver import BaseReviver


class ReviverWithFilter(BaseReviver):
    def __init__(self, process_name, apply_options=None, log_context_getter=None, additional_filter=None):
        super(ReviverWithFilter, self).__init__(process_name, apply_options, log_context_getter)
        self.additional_filter = additional_filter if additional_filter else {}

    def _prepare_query(self):
        query = super(ReviverWithFilter, self)._prepare_query()
        for key in self.additional_filter:
            query['$and'].append({key: self.additional_filter[key]})
        return query


def revive(process_name, apply_options=None, log_context_getter=None, additional_filter=None):
    """
    Воскрешает процессы workflow.Process, которые были остановлены по каким-то причинам.
    :param process_name - Имя процесса из реестра.
    :param apply_options - параметры, которые будут переданы как kwargs в apply_async.
    :param log_context_getter - функция получения контекста из документа.
    :param additional_filter - дополнительный словарь-фильтр документов в Mongo ({'<поле>': {<условие>},}).
    """
    ReviverWithFilter(process_name, apply_options, log_context_getter, additional_filter).execute()
