# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.data_api.billing.trust_client import TrustClient, TrustClientRequestError
from common.settings.utils import define_setting
from common.utils.date import UTC_TZ
from common.utils.try_hard import try_hard

define_setting('WORKFLOW_LOCK_ALIVE_TIME', default=60, converter=int)
define_setting('WORKFLOW_LOCK_UPDATE_INTERVAL_SECONDS', default=15, converter=int)


def make_partner_data_update(order, order_info):
    ln = order.current_partner_data_lookup_name
    update_spec = {'set__{}__order_num'.format(ln): order_info.order_num}
    if order_info.expire_set_er:
        update_spec['set__{}__expire_set_er'.format(ln)] = order_info.expire_set_er.astimezone(UTC_TZ)
    return update_spec


@try_hard(retriable_exceptions=(TrustClientRequestError,))
def _safe_unhold_payment(trust_client, purchase_token):
    trust_client.unhold_payment(purchase_token)


def unhold_payment(order, payment=None):
    trust_client = TrustClient(user_ip=order.user_info.ip,
                               user_passport_uid=order.user_info.uid,
                               user_region_id=order.user_info.region_id)
    return _safe_unhold_payment(trust_client, (payment or order.current_billing_payment).purchase_token)


@try_hard(retriable_exceptions=(TrustClientRequestError,))
def _safe_get_payment_status(trust_client, purchase_token):
    return trust_client.get_payment_status(purchase_token)


def get_payment_status(order, payment=None):
    trust_client = TrustClient(user_ip=order.user_info.ip,
                               user_passport_uid=order.user_info.uid,
                               user_region_id=order.user_info.region_id)
    return _safe_get_payment_status(trust_client, (payment or order.current_billing_payment).purchase_token)
