# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.workflow.process import StateAction
from travel.rasp.train_api.train_partners.base.confirm_ticket import cancel_order

log = logging.getLogger(__name__)


class CancelOrderEvents(object):
    OK = 'ok'


class CancelOrder(StateAction):
    def do(self, _data):
        order = self.document
        update_spec = {}

        try:
            cancel_order(order)
            update_spec.update({'set__{}__is_order_cancelled'.format(order.current_partner_data_lookup_name): True})
        except Exception:
            log.exception('Error while trying to cancel order {}'.format(order.id))

        return CancelOrderEvents.OK, update_spec
