# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_payment
from travel.rasp.train_api.train_purchase.workflow.user_events import PaymentUserEvents


class CancelPaymentEvents(object):
    OK = 'ok'


class CancelPayment(StateAction):
    def do(self, _data):
        order = self.document
        send_event_to_payment(order.current_billing_payment, PaymentUserEvents.ABORT_PAYMENT)
        return CancelPaymentEvents.OK
