# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.enums import InsuranceStatus, OrderStatus, RebookingStatus


class CheckInsuranceEvents(object):
    OK = 'ok'
    FAILED = 'failed'


class CheckInsurance(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document

        if order.insurance.status == InsuranceStatus.CHECKED_OUT or not order.current_billing_payment.purchase_token:
            return CheckInsuranceEvents.OK
        else:
            update_spec = {
                'set__status': OrderStatus.CONFIRM_FAILED,
                'set__rebooking_info__status': RebookingStatus.FAILED,
            }
            return CheckInsuranceEvents.FAILED, update_spec
