# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.conf import settings

from common.dynamic_settings.default import conf
from common.email_sender import guaranteed_send_email
from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from common.workflow.process import StateAction
from travel.rasp.train_api.train_partners.base.insurance.checkout import checkout
from travel.rasp.train_api.train_purchase.core.enums import InsuranceStatus

log = logging.getLogger(__name__)

define_setting('INSURANCE_ERROR_CAMPAIGN', {
    Configuration.PRODUCTION: 'WGJE1J13-ZWT1',
    Configuration.TESTING: '4B930J13-X4S1',
    Configuration.DEVELOPMENT: '4B930J13-X4S1'
}, default=None)


class CheckoutInsuranceEvents(object):
    DONE = 'done'
    FAILED = 'failed'


class CheckoutInsurance(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document

        try:
            checkout(order)
            return CheckoutInsuranceEvents.DONE, {'set__insurance__status': InsuranceStatus.CHECKED_OUT}
        except Exception:
            log.exception('order %s failed during CheckoutInsurance', order.uid)
            guaranteed_send_email(
                key='insurance_error_email_{}'.format(order.uid),
                to_email=conf.TRAIN_PURCHASE_ERRORS_EMAIL,
                args={'order_uid': order.uid},
                campaign=settings.INSURANCE_ERROR_CAMPAIGN,
                log_context={'order_uid': order.uid},
            )
            return CheckoutInsuranceEvents.FAILED, {'set__insurance__status': InsuranceStatus.FAILED}
