# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.workflow.process import StateAction
from travel.rasp.train_api.helpers.error import build_error_info
from travel.rasp.train_api.train_partners.base.confirm_ticket import confirm_order, cancel_order
from travel.rasp.train_api.train_partners.im.base import ImError
from travel.rasp.train_api.train_purchase.core.enums import OrderStatus, TravelOrderStatus
from travel.rasp.train_api.train_purchase.workflow.base import make_partner_data_update

log = logging.getLogger(__name__)


class ConfirmOrderEvents(object):
    OK = 'ok'
    IM_FAILED_NO_RETRY = 'im_failed_no_retry'
    FAILED = 'failed'


class ConfirmOrder(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document
        try:
            result = confirm_order(order)
            update_spec = {}
            update_spec.update(make_partner_data_update(order, result))

            return ConfirmOrderEvents.OK, update_spec
        except ImError as im_error:
            if not im_error.is_communication_error():
                update_spec = {
                    'set__status': OrderStatus.CONFIRM_FAILED,
                    'set__travel_status': TravelOrderStatus.CANCELLED,
                    'set__error': build_error_info(im_error)
                }
                try:
                    cancel_order(self.document)
                    update_spec.update(
                        {'set__{}__is_order_cancelled'.format(order.current_partner_data_lookup_name): True}
                    )
                except Exception:
                    log.exception('Error while trying to cancel order {}'.format(self.document.id))

                return ConfirmOrderEvents.IM_FAILED_NO_RETRY, update_spec
            else:
                log.exception('Error in ReserveOrder')
                return ConfirmOrderEvents.FAILED, {}
        except Exception:
            log.exception('Error in ReserveOrder')
            return ConfirmOrderEvents.FAILED, {}
