# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import socket
from datetime import timedelta

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction, ActionResult
from common.workflow.registry import run_process
from common.workflow.sleep import WaitTillStatuses
from travel.rasp.train_api.train_purchase.core.models import TrainRefund, RefundStatus, RefundUserInfo
from travel.rasp.train_api.train_purchase.workflow.ticket_refund import TICKET_REFUND_PROCESS

log = logging.getLogger(__name__)

INSURANCE_REFUND_WAIT_INTERVAL = timedelta(minutes=3)


class CreateInsuranceRefund(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document

        refund = TrainRefund.objects.create(
            order_uid=order.uid,
            is_active=True,
            status=RefundStatus.NEW,
            blank_ids=[],
            insurance_ids=[p.insurance.operation_id for p in order.passengers
                           if p.insurance and p.insurance.operation_id],
            user_info=RefundUserInfo(ip='127.0.0.1', uid=socket.gethostname(), region_id=213),
            is_external=False,
            created_at=now_utc(),
            email_is_sent=True,
        )
        run_process.apply_async([TICKET_REFUND_PROCESS, str(refund.id), {'order_uid': order.uid}])
        update_spec = {'insurance_auto_return_uuid': refund.uuid}
        wait_till = now_utc() + INSURANCE_REFUND_WAIT_INTERVAL
        return ActionResult(WaitTillStatuses.OK, wait_till=wait_till, doc_update=update_spec)
