# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.workflow.process import StateAction
from common.workflow.registry import run_process
from travel.rasp.train_api.train_purchase.workflow.payment import PAYMENT_PROCESS

log = logging.getLogger(__name__)


class CreatePaymentEvents(object):
    OK = 'ok'
    ORDER_CANCELLED = 'order_cancelled'
    PAYMENT_ALREADY_STARTED = 'payment_already_started'


class CreatePayment(StateAction):
    def do(self, _data, *_args, **_kwargs):
        order = self.document
        if order.current_partner_data.is_order_cancelled:
            log.warning('Попытка оплаты при отмененной брони')
            return CreatePaymentEvents.ORDER_CANCELLED

        current_payment = order.current_billing_payment
        if current_payment.purchase_token:
            log.info('Попытка оплаты уже запущена')
            return CreatePaymentEvents.PAYMENT_ALREADY_STARTED

        run_process.apply_async([
            PAYMENT_PROCESS,
            str(current_payment.id),
            {'order_uid': order.uid, 'payment': current_payment.uid}
        ])
        return CreatePaymentEvents.OK
