# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import time

from common.workflow.process import StateAction


logger = logging.getLogger(__name__)
yt_order_logger = logging.getLogger('yt_order_logger')


class LogOrderEvents(object):
    OK = 'ok'


class LogOrder(StateAction):
    def do(self, _data):
        """
        Пишем данные по заказу для статистики в YT через JSON-файл
        """
        try:
            order = self.document

            num_of_tickets = 0
            amount = 0
            fee = 0
            fee_without_im = 0
            for t in order.iter_tickets():
                num_of_tickets += 1
                amount += t.payment.amount
                fee += t.payment.fee
                fee_without_im += t.payment.fee - t.payment.partner_fee

            yt_order_logger.info(msg=None, extra={
                'timestamp': int(time.time()),
                'order_uid': order.uid,
                'request_id': order.source.req_id if order.source else None,
                'reserved_to': int(time.mktime(order.reserved_to.timetuple())),
                'num_of_tickets': num_of_tickets,
                'amount': float(amount),
                'fee': float(fee),
                'fee_without_im': float(fee_without_im),
                'device': order.source.device.value if order.source and order.source.device else None,
                'yandex_uid': order.user_info.yandex_uid,
            })
        except Exception as e:
            logger.exception(e)

        return LogOrderEvents.OK
