# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.enums import InsuranceStatus

log = logging.getLogger(__name__)


class SetInsuranceStatusEvents(object):
    DONE = 'done'
    SKIPPED = 'skipped'
    FAILED = 'failed'


class SetInsuranceStatus(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document
        status = order.insurance.status if order.insurance else None

        if not order.insurance_enabled or status in (None, InsuranceStatus.DECLINED, InsuranceStatus.CHECKED_OUT):
            return SetInsuranceStatusEvents.SKIPPED, {}
        elif status == InsuranceStatus.ACCEPTED:
            return SetInsuranceStatusEvents.DONE, {'set__insurance__status': InsuranceStatus.CHECKING_OUT}
        else:
            log.error('Order %s has invalid insurance.status %s', order.uid, status)
            return SetInsuranceStatusEvents.FAILED, {}
