# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

import settings

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.workflow.booking.check_order import CHECK_ORDER_DELAY_SECONDS


class SetMaxPendingTillEvents(object):
    OK = 'ok'
    RETRY = 'retry'


class SetMaxPendingTill(StateAction):
    def do(self, _data):
        """
        Устанавливает для заказа max_pending_till как пограничное время обновления статуса.
        При повторном обращении возвращает евент RETRY для перехода к CheckOrder
        :param _data:
        :return:
        """
        return SetMaxPendingTillEvents.OK if not self.document.max_pending_till else SetMaxPendingTillEvents.RETRY, {
            'set__max_pending_till': (now_utc() + timedelta(seconds=max(
                settings.DEFAULT_PARTNER_TIMEOUT, CHECK_ORDER_DELAY_SECONDS
            ))).replace(microsecond=0),
        }
