# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.enums import OrderStatus, TravelOrderStatus


class UpdateOrderStatusEvents(object):
    OK = 'ok'


class UpdateOrderStatus(StateAction):
    def do(self, data, order_status=None, **kwargs):
        if not order_status:
            raise Exception()
        update_spec = {'set__status': order_status}
        if order_status == OrderStatus.RESERVED:
            update_spec['set__travel_status'] = TravelOrderStatus.RESERVED
        elif order_status == OrderStatus.PAID:
            update_spec['set__finished_at'] = now_utc()
            update_spec['set__travel_status'] = TravelOrderStatus.IN_PROGRESS
        if order_status in [OrderStatus.CANCELLED, OrderStatus.START_PAYMENT_FAILED, OrderStatus.PAYMENT_FAILED,
                            OrderStatus.PAYMENT_OUTDATED, OrderStatus.CONFIRM_FAILED]:
            update_spec['set__travel_status'] = TravelOrderStatus.CANCELLED
        if order_status == OrderStatus.DONE:
            update_spec['set__travel_status'] = TravelOrderStatus.DONE
        return UpdateOrderStatusEvents.OK, update_spec
