# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.utils.try_hard import try_hard
from common.workflow.process import StateAction
from travel.rasp.train_api.train_partners.base.get_order_info import get_order_info
from travel.rasp.train_api.train_purchase.core.enums import OperationStatus, OrderStatus
from travel.rasp.train_api.train_purchase.utils.order import make_ticket_statuses_update, make_order_status_update

log = logging.getLogger(__name__)


class UpdateTicketStatuses(object):
    FAILED = 'failed'
    DONE = 'done'


class UpdateOrderTickets(StateAction):
    def do(self, data, *args, **kwargs):
        order_info = try_hard()(get_order_info)(self.document)

        if order_info.status != OperationStatus.OK:
            return UpdateTicketStatuses.FAILED, {}
        else:
            update_spec = make_ticket_statuses_update(self.document, order_info.tickets)
            update_spec.update(make_order_status_update(self.document, order_info))
            update_spec.update({'set__status': OrderStatus.DONE})
            return UpdateTicketStatuses.DONE, update_spec
