# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.data_api.billing.trust_client import TrustPaymentStatuses
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.workflow.base import unhold_payment, get_payment_status

log = logging.getLogger(__name__)


class CancelPaymentEvents(object):
    OK = 'ok'


class CancelPayment(StateAction):
    def do(self, _data):
        payment = self.document
        try:
            if (
                payment.purchase_token
                and get_payment_status(payment.order, payment) == TrustPaymentStatuses.AUTHORIZED
            ):
                # если оплата произойдёт после этой проверки, то она отменится автоматически из-за отсутствия клиринга
                unhold_payment(payment.order, payment)
                log.info('Успешно провели отмену платежа.')
        except Exception:
            log.exception('Ошибка при анхолде')

        return CancelPaymentEvents.OK, {'set__status': TrustPaymentStatuses.CANCELED.value}
