# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.date.environment import now_utc
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.utils.order import send_event_to_order
from travel.rasp.train_api.train_purchase.workflow.user_events import TrainBookingUserEvents


class RebookOrderEvents(object):
    DONE = 'done'
    SKIPPED = 'skipped'


class RebookOrder(StateAction):
    def do(self, data, *args, **kwargs):
        order = self.document.order

        if (not order.rebooking_info
                or not order.rebooking_info.cycle_until
                or order.rebooking_info.cycle_until > now_utc()):
            return RebookOrderEvents.SKIPPED
        else:
            send_event_to_order(order, TrainBookingUserEvents.REBOOKING)
            return RebookOrderEvents.DONE
