# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.data_api.billing.trust_client import (
    TrustClient, TrustClientRequestError, train_order_skip_trust
)
from travel.rasp.library.python.common23.date import environment
from common.utils.try_hard import try_hard
from common.workflow.process import StateAction
from travel.rasp.train_api.train_purchase.core.models import RefundPaymentStatus
from travel.rasp.train_api.train_purchase.workflow.payment.create_refund_payment import calculate_refund_payment_orders

log = logging.getLogger(__name__)

CHECK_PAYMENT_CLEARED_SLEEP_DURATION = 5
CHECK_PAYMENT_CLEARED_MAX_RETRIES = 3

REFUND_FAILED_MESSAGE = 'Не смогли вернуть деньги пользователю.'
REFUND_FAILED_MESSAGE_WITH_RETRY = 'Не смогли вернуть деньги пользователю. Попробуем повторить позже.'


class ResizePaymentEvents(object):
    OK = 'ok'


class ResizePayment(StateAction):
    def do(self, _data, event_params, *_args, **_kwargs):
        payment = self.document
        payment.current_refund_payment_id = event_params
        refund_payment = payment.current_refund_payment
        payment_update_spec = {'current_refund_payment_id': event_params}

        if train_order_skip_trust() or payment.immediate_return:
            return ResizePaymentEvents.OK, payment_update_spec

        order = payment.order
        refund_orders = calculate_refund_payment_orders(order, refund_payment)

        trust_client = TrustClient(user_ip=refund_payment.user_info.ip,
                                   user_region_id=refund_payment.user_info.region_id)

        # намеренно не отлавливаем исключения, чтобы пришло письмо с unhandled_exception,
        # т.к. нужно будет разобраться прошел ли ресайз по каждой позиции
        for refund_order in refund_orders:
            resize_payment_order(trust_client, refund_payment.purchase_token,
                                 refund_order.order_id, refund_order.result_amount)

        refund_payment_update_spec = {
            'set__refund_payment_status': RefundPaymentStatus.UNKNOWN,
            'set__refund_payment_finished_at': environment.now_utc(),
            'set__payment_resized': True,
        }
        refund_payment.update(**refund_payment_update_spec)
        return ResizePaymentEvents.OK, payment_update_spec


@try_hard(retriable_exceptions=(TrustClientRequestError,))
def resize_payment_order(trust_client, purchase_token, order_id, amount):
    trust_client.resize_payment_order(purchase_token, order_id, amount)
